proc tabulate data = ghpb21;

class ent3 INS3 filingsize / PRELOADFMT;
title 'Table A3. Number of Participants in Group Health Plans';
title2 'by type of insurance, type of plan, and type of participant, 2021';
title3 '(thousands)';
title4 'All Plans';
var TOT_ACTIVE_PARTCP_CNE RTD_SEP_PARTCP_RCVG_CNE RTD_SEP_PARTCP_FUT_CNE SUBTL_ACT_RTD_SEP_CNE;
weight dup_wgt;
table (TOT_ACTIVE_PARTCP_CNE='Active Participants, End of Year' 
RTD_SEP_PARTCP_RCVG_CNE='Retired or Separated Participants Receiving Benefits, End of Year' 
RTD_SEP_PARTCP_FUT_CNE='Other Retired or Separated Participants Entitled to Future Benefits, End of Year'
SUBTL_ACT_RTD_SEP_CNE='Total Participants, End of Year')*sum=' '*f=k12f., 
(all='All Plans' INS3=' ')*(all='Total' ent3=' ')/ Box='Type of Participant' MISSTEXT='-';
run;

proc tabulate data = ghpb21;
WHERE FILINGSIZE='1';
class ent3 INS3 filingsize / PRELOADFMT;
title 'Table A3. Number of Participants in Group Health Plans';
title2 'by type of insurance, type of plan, and type of participant, 2021';
title3 '(thousands)';
title4 'Plans with 100 or More Participants and Trusts';
var TOT_ACTIVE_PARTCP_CNE RTD_SEP_PARTCP_RCVG_CNE RTD_SEP_PARTCP_FUT_CNE SUBTL_ACT_RTD_SEP_CNE;
weight dup_wgt;
table (TOT_ACTIVE_PARTCP_CNE='Active Participants, End of Year' 
RTD_SEP_PARTCP_RCVG_CNE='Retired or Separated Participants Receiving Benefits, End of Year' 
RTD_SEP_PARTCP_FUT_CNE='Other Retired or Separated Participants Entitled to Future Benefits, End of Year'
SUBTL_ACT_RTD_SEP_CNE='Total Participants, End of Year')*sum=' '*f=k12f., 
(all='All Plans' INS3=' ')*(all='Total' ent3=' ')/ Box='Type of Participant' MISSTEXT='-';
run;

proc tabulate data = ghpb21;
WHERE FILINGSIZE='2';
class ent3 INS3 filingsize / PRELOADFMT;
title 'Table A3. Number of Participants in Group Health Plans';
title2 'by type of insurance, type of plan, and type of participant, 2021';
title3 '(thousands)';
title4 'Plans with 100 or More Participants and No Trusts';
var TOT_ACTIVE_PARTCP_CNE RTD_SEP_PARTCP_RCVG_CNE RTD_SEP_PARTCP_FUT_CNE SUBTL_ACT_RTD_SEP_CNE;
weight dup_wgt;
table (TOT_ACTIVE_PARTCP_CNE='Active Participants, End of Year' 
RTD_SEP_PARTCP_RCVG_CNE='Retired or Separated Participants Receiving Benefits, End of Year' 
RTD_SEP_PARTCP_FUT_CNE='Other Retired or Separated Participants Entitled to Future Benefits, End of Year'
SUBTL_ACT_RTD_SEP_CNE='Total Participants, End of Year')*sum=' '*f=k12f., 
(all='All Plans' INS3=' ')*(all='Total' ent3=' ')/ Box='Type of Participant' MISSTEXT='-';
run;

proc tabulate data = ghpb21;
WHERE FILINGSIZE='3';
class ent3 INS3 filingsize / PRELOADFMT;
title 'Table A3. Number of Participants in Group Health Plans';
title2 'by type of insurance, type of plan, and type of participant, 2021';
title3 '(thousands)';
title4 'Plans with Fewer Than 100 Participants and Trusts';
var TOT_ACTIVE_PARTCP_CNE RTD_SEP_PARTCP_RCVG_CNE RTD_SEP_PARTCP_FUT_CNE SUBTL_ACT_RTD_SEP_CNE;
weight dup_wgt;
table (TOT_ACTIVE_PARTCP_CNE='Active Participants, End of Year' 
RTD_SEP_PARTCP_RCVG_CNE='Retired or Separated Participants Receiving Benefits, End of Year' 
RTD_SEP_PARTCP_FUT_CNE='Other Retired or Separated Participants Entitled to Future Benefits, End of Year'
SUBTL_ACT_RTD_SEP_CNE='Total Participants, End of Year')*sum=' '*f=k12f., 
(all='All Plans' INS3=' ')*(all='Total' ent3=' ')/ Box='Type of Participant' MISSTEXT='-';
run;
